unit Labels;

interface

uses Classes, SysUtils;

type
  PScmLabel = ^TScmLabel;
  TScmLabel = record
    Name: PChar;
    Offset: Longword;
  end;

  TLabels = class
  private
    function GetCount: Integer;
  public
    FLabels: TList;
    FLabelsByName: TList;
    constructor Create;
    destructor Destroy; override;
    procedure Add(Name: string; Len: Integer; Offset: Longword);
    function IndexOf(Name: string): Integer;
    function GetOffset(Name: string): Integer;
    procedure dump;
    property Count: Integer read GetCount;
  end;

implementation

constructor TLabels.Create;
begin
  inherited;
  FLabels := TList.Create;
  FLabelsByName := TList.Create;
end;

destructor TLabels.Destroy;
var
  i: Integer;
begin
  for i := 0 to FLabels.Count -1 do
  begin
    FreeMem(PScmLabel(FLabels.List[i]).Name);
    FreeMem(FLabels.List[i]);
  end;
  FLabels.Free;
  FLabelsByName.Free;
  inherited
end;

procedure TLabels.Add(Name: string; Len: Integer; Offset: Longword);
var
  First, Mid, Last, i: Integer;
  P: PScmLabel;
begin
  First := 0;
  Last := FLabelsByName.Count -1;

  if Last >= 0 then
  begin
    while First <= Last do
    begin
      Mid := (First + Last) div 2;
      i := StrIComp(PChar(Name), PScmLabel(FLabelsByName[Mid]).Name);
      if i = 0 then
      begin
        Exit;
      end;
      if i < 0 then
        last := mid -1
      else
        first := mid + 1;
    end;

    if i > 0 then
      Inc(Mid);
  end
  else
    Mid := 0;

  New(P);
  GetMem(P.Name, Len+1);
  Move(Name[1], P.Name^, Len+1);
  P.Offset := Offset;
  FLabelsByName.Insert(Mid, P);
  FLabels.Add(P);
end;

function TLabels.IndexOf(Name: string): Integer;
var
  First, Mid, Last, i: Integer;
begin
  Result := -1;
  First := 0;
  Last := FLabelsByName.Count -1;

  while First <= Last do
  begin
    Mid := (First + Last) div 2;
    // CompareText better?
    i := StrIComp(PChar(Name), PScmLabel(FLabelsByName.Items[Mid]).Name);
    if i = 0 then
    begin
      Result := Mid;
      Exit;
    end;
    if i < 0 then
      last := mid -1
    else
      first := mid + 1;
  end;
end;

function TLabels.GetOffset(Name: string): Integer;
var
  i: Integer;
  l: Longword;
begin
  i := IndexOf(Name);
  if i = -1 then
    Result := -1
  else
    result := PScmLabel(FLabelsByName[i]).Offset;
end;

function TLabels.GetCount: Integer;
begin
  Result := FLabels.Count;
end;

procedure TLabels.dump;
var
  i: Integer;
begin
  for i := 0 to FLabelsByName.Count-1 do
    Writeln(PChar(PScmLabel(FLabelsByName[i]).Name));
end;

end.
