unit Variables;

interface

uses Classes, SysUtils;

type
  TVariables = class
  private
    FVars: TList;
    function GetCount: Integer;
  public
    constructor Create;
    destructor Destroy; override;
    procedure Add(Name: string; Len: Integer);
    function IndexOf(Name: PChar): Integer;

    procedure dump;
    property Count: Integer read GetCount;
  end;

implementation

constructor TVariables.Create;
var
  P: Pointer;
  s: string;
begin
  FVars := TList.Create;
  s := 'dummy';
  GetMem(P, 6);
  move(s[1], p^, 6);
  FVars.Add(P);
end;

destructor TVariables.Destroy;
var
  i: Integer;
begin
  for i := 0 to FVars.Count -1 do
  begin
    FreeMem(FVars.List[i]);
  end;
  FVars.Free;
end;

procedure TVariables.Add(Name: string; Len: Integer);
var
  First, Mid, Last, i: Integer;
  P: Pointer;
begin
  First := 0;
  Last := FVars.Count -1;

  if Last >= 0 then
    while First <= Last do
    begin
      Mid := (First + Last) div 2;
      i := StrIComp(PChar(Name),  FVars.Items[Mid]);
      if i = 0 then
      begin
        //Writeln('n');
        Exit;
      end;

      if i < 0 then
        last := mid -1
      else
        first := mid + 1;
    end;

  if i > 0 then
    Inc(Mid);

  GetMem(P, Len+1);
  Move(Name[1], P^, Len+1);
  FVars.Insert(Mid, P);
end;

function TVariables.IndexOf(Name: PChar): Integer;
var
  First, Mid, Last, i: Integer;
begin
  Result := -1;
  First := 0;
  Last := FVars.Count -1;

  while First <= Last do
  begin
    Mid := (First + Last) div 2;
    i := StrIComp(Name, FVars.Items[Mid]);
    if i = 0 then
    begin
      Result := Mid;
      Exit;
    end;

    if i < 0 then
      last := mid -1
    else
      first := mid + 1;
  end;
end;

function TVariables.GetCount: Integer;
begin
  Result := FVars.Count;
end;

procedure TVariables.dump;
var
  i: Integer;
begin
  for i := 0 to FVars.Count-1 do
    Writeln(PChar(FVars.Items[i]));
end;

end.

