unit FastStringList;
// Note: sorted, no duplicates & case insensitive

interface

uses Classes, SysUtils;

type
  TFastStringList = class
  private
    FLines: TList;
    function GetCount: Integer;
  public
    constructor Create;
    destructor Destroy; override;
    function Add(Name: string; Len: Integer): Integer;
    procedure Clear;
    function IndexOf(Name: PChar): Integer;
    function GetString(Index: Integer): PChar;
    property Count: Integer read GetCount;
  end;

implementation

constructor TFastStringList.Create;
begin
  FLines := TList.Create;
end;

destructor TFastStringList.Destroy;
var
  i: Integer;
begin
  for i := 0 to FLines.Count -1 do
  begin
    FreeMem(FLines.List[i]);
  end;
  FLines.Free;
end;

function TFastStringList.Add(Name: string; Len: Integer): Integer;
var
  First, Mid, Last, i: Integer;
  P: Pointer;
begin
  First := 0;
  Last := FLines.Count -1;
  if Last >= 0 then
  begin
    while First <= Last do
    begin
      Mid := (First + Last) div 2;
      i := StrIComp(PChar(Name),  FLines.Items[Mid]);
      if i = 0 then
      begin
        Result := Mid;
        Exit;
      end;
      if i < 0 then
        last := mid -1
      else
        first := mid + 1;
    end;
    if i > 0 then
      Inc(Mid);
  end
  else
    Mid := 0;

  GetMem(P, Len+1);
  //make go away :)
  Name := UPPERCASE(Name);
  Move(Name[1], P^, Len+1);
  FLines.Insert(Mid, P);
  Result := Mid;
end;

procedure TFastStringList.Clear;
var
  i: Integer;
begin
  for i := 0 to FLines.Count -1 do
  begin
    FreeMem(FLines.List[i]);
  end;
  FLines.Clear;
end;

function TFastStringList.IndexOf(Name: PChar): Integer;
var
  First, Mid, Last, i: Integer;
begin
  Result := -1;
  First := 0;
  Last := FLines.Count -1;

  while First <= Last do
  begin
    Mid := (First + Last) div 2;
    i := StrIComp(Name, FLines.Items[Mid]);
    if i = 0 then
    begin
      Result := Mid;
      Exit;
    end;

    if i < 0 then
      last := mid -1
    else
      first := mid + 1;
  end;
end;

function TFastStringList.GetCount: Integer;
begin
  Result := FLines.Count;
end;

function TFastStringList.GetString(Index: Integer): PChar;
begin
  Result := FLines.Items[Index];
end;

end.

