/*
 * Decompiled with CFR 0.152.
 */
package thehambone.gtatools.gtasum.gui;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class OutputPanel
extends JPanel {
    private static final PrintStream STDOUT = new PrintStream(new FileOutputStream(FileDescriptor.out));
    private static final PrintStream STDERR = new PrintStream(new FileOutputStream(FileDescriptor.err));
    private final DocumentOutputStream documentOutputStreamOut;
    private final DocumentOutputStream documentOutputStreamErr;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private JPopupMenu popupMenu;
    private JMenuItem clearOutputMenuItem;

    public OutputPanel() {
        this.initComponents();
        this.initPopupMenu();
        this.documentOutputStreamOut = new DocumentOutputStream(this.textArea);
        this.documentOutputStreamErr = new DocumentOutputStream(this.textArea);
        this.documentOutputStreamOut.teeOutput(STDOUT);
        this.documentOutputStreamErr.teeOutput(STDERR);
        System.setOut(new PrintStream(this.documentOutputStreamOut));
        System.setErr(new PrintStream(this.documentOutputStreamErr));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setCursor(Cursor.getPredefinedCursor(2));
        this.textArea.setComponentPopupMenu(this.popupMenu);
        this.textArea.setFont(new Font("Monospaced", 0, 11));
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 3 && evt.getClickCount() == 1 && !OutputPanel.this.textArea.getText().isEmpty()) {
                    OutputPanel.this.popupMenu.show(OutputPanel.this.textArea, evt.getX(), evt.getY());
                }
            }
        });
        this.scrollPane = new JScrollPane(this.textArea);
        this.add(this.scrollPane);
    }

    private void initPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.clearOutputMenuItem = new JMenuItem("Clear Output");
        this.clearOutputMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.textArea.setText("");
            }
        });
        this.popupMenu.add(this.clearOutputMenuItem);
    }

    private class DocumentOutputStream
    extends OutputStream {
        private final JTextArea textArea;
        private final Document doc;
        private PrintStream tee;

        public DocumentOutputStream(JTextArea textArea) {
            this.textArea = textArea;
            this.doc = textArea.getDocument();
        }

        public void teeOutput(PrintStream tee) {
            this.tee = tee;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.doc.insertString(this.doc.getLength(), String.valueOf(b), null);
                this.textArea.setCaretPosition(this.doc.getLength());
                if (this.tee != null) {
                    this.tee.write(b);
                }
            }
            catch (BadLocationException ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                System.err.printf("[ERROR]: %s\n", sw.toString());
                JOptionPane.showMessageDialog(null, "An error has occured:\n\n" + ex.toString(), "Error", 0);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.doc.insertString(this.doc.getLength(), new String(b, off, len), null);
                this.textArea.setCaretPosition(this.doc.getLength());
                if (this.tee != null) {
                    this.tee.write(b, off, len);
                }
            }
            catch (BadLocationException ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                System.err.printf("[ERROR]: %s\n", sw.toString());
                JOptionPane.showMessageDialog(null, "An error has occured:\n\n" + ex.toString(), "Error", 0);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }
    }
}

