/*
 * Decompiled with CFR 0.152.
 */
package thehambone.gtatools.gtasum.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import thehambone.gtatools.gtasum.checksum.Checksum;
import thehambone.gtatools.gtasum.gui.Window;

public class DropPanel
extends JPanel {
    private JLabel dropMessage;
    private DropTarget dropTarget;
    private DropTargetHandler dropTargetHandler;

    public DropPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.dropMessage = new JLabel("Drop your GTA gamesaves here!");
        this.dropMessage.setFont(this.dropMessage.getFont().deriveFont(0, 18.0f));
        this.dropMessage.setHorizontalAlignment(0);
        this.add((Component)this.dropMessage, "Center");
    }

    public void importFiles(ArrayList<File> fileList) {
        Iterator<File> i = fileList.iterator();
        while (i.hasNext()) {
            File f = i.next();
            String fileName = f.getName();
            boolean skipFile = false;
            if (f.isDirectory()) {
                i.remove();
                System.out.printf("[INFO] Skipping directory - %s\n", fileName);
                this.showIsDirectoryError(fileName);
                continue;
            }
            if (fileName.contains(".")) {
                String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
                if (!extension.equalsIgnoreCase("b")) {
                    skipFile = this.showFileTypeWarning(fileName);
                }
            } else {
                skipFile = this.showFileTypeWarning(fileName);
            }
            if (!skipFile) continue;
            i.remove();
            System.out.printf("[INFO]: Skipping file - %s\n", fileName);
        }
        int filesUpdated = 0;
        for (File f : fileList) {
            try {
                filesUpdated += Checksum.calculateChecksum(f) ? 1 : 0;
            }
            catch (IOException ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                System.err.printf("[ERROR]: %s\n", sw.toString());
                JOptionPane.showMessageDialog(this, "An error has occured:\n\n" + ex.toString(), "Error", 0);
            }
        }
        Toolkit.getDefaultToolkit().beep();
        String filesUpdatedString = String.format("%d %s updated.", filesUpdated, filesUpdated == 1 ? "file" : "files");
        System.out.printf("[INFO]: %s\n", filesUpdatedString);
        JOptionPane.showMessageDialog(this, filesUpdatedString, "Complete", 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(375, 225);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        try {
            this.getMyDropTarget().addDropTargetListener(this.getDropTargetHandler());
        }
        catch (TooManyListenersException ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            System.err.printf("[ERROR]: %s\n", sw.toString());
            JOptionPane.showMessageDialog(this, "An error has occured:\n\n" + ex.toString(), "Error", 0);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.getMyDropTarget().removeDropTargetListener(this.getDropTargetHandler());
    }

    private DropTarget getMyDropTarget() {
        if (this.dropTarget == null) {
            this.dropTarget = new DropTarget(this, 3, null);
        }
        return this.dropTarget;
    }

    private DropTargetHandler getDropTargetHandler() {
        if (this.dropTargetHandler == null) {
            this.dropTargetHandler = new DropTargetHandler();
        }
        return this.dropTargetHandler;
    }

    private boolean showFileTypeWarning(String fileName) {
        int option = JOptionPane.showOptionDialog(this, "<html><p style='width: 200px;'>\"" + fileName + "\" may not be a GTA III-era save file.<br>" + "<br>" + "Continue?</p></html>", "Warning", 0, 2, null, null, null);
        return option != 0;
    }

    private void showIsDirectoryError(String fileName) {
        JOptionPane.showMessageDialog(this, "<html><p style='width: 200px;'>\"" + fileName + "\" is a directory.", "Error", 0);
    }

    private class DropTargetHandler
    implements DropTargetListener {
        private DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this.processDrag(dtde);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this.processDrag(dtde);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(dtde.getDropAction());
                try {
                    List transferData = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    if (transferData != null && !transferData.isEmpty()) {
                        if (!Window.getCurrentWindow().hasOutputPanelBeenVisible()) {
                            Window.getCurrentWindow().setOutputPanelVisible(true);
                        }
                        DropPanel.this.importFiles(new ArrayList<File>(transferData));
                        dtde.dropComplete(true);
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    StringWriter sw = new StringWriter();
                    ex.printStackTrace(new PrintWriter(sw));
                    System.err.printf("[ERROR]: %s\n", sw.toString());
                    JOptionPane.showMessageDialog(DropPanel.this, "An error has occured:\n\n" + ex.toString(), "Error", 0);
                }
            } else {
                dtde.rejectDrop();
            }
        }

        private void processDrag(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrag(1);
            } else {
                dtde.rejectDrag();
            }
        }
    }
}

