local testmodule = {}
testmodule.loaded = false
testmodule.zombies = {}
testmodule.spawnedvehicle = nil
function testmodule.unload()
	if( testmodule.spawnedvehicle ~= nil) then
		VEHICLE.DELETE_VEHICLE(testmodule.spawnedvehicle)
	end
	for k,zombie in pairs(testmodule.zombies) do
		if( zombie ~= nil) then
			PED.DELETE_PED(zombie)
			testmodule.zombies[k] = nil
		end
	end
end
function testmodule.tick()
	local zombieSkinID = GAMEPLAY.GET_HASH_KEY("u_m_y_zombie_01")
	local playerPed = PLAYER.PLAYER_PED_ID()
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	local playerID = PLAYER.PLAYER_ID()
	local playerExists = ENTITY.DOES_ENTITY_EXIST(playerPed)
	local playerPosition = ENTITY.GET_OFFSET_FROM_ENTITY_IN_WORLD_COORDS(playerPed, 0.0, 5.0, 0.0)
	local playerGroup = PED.GET_PED_GROUP_INDEX(playerPed)
	if(testmodule.loaded) then 
	
        

		STREAMING.REQUEST_MODEL(zombieSkinID)
		while(not STREAMING.HAS_MODEL_LOADED(zombieSkinID)) do
				wait(50)
		end
		local closestVehicle = VEHICLE.GET_CLOSEST_VEHICLE(playerPosition.x, playerPosition.y, playerPosition.z, 50, 0, 64)
		print(closestVehicle)
		testmodule.spawnedvehicle = closestVehicle
		for i = 0 ,2,1 do
			testmodule.zombies[i] = PED.CREATE_PED( 26,zombieSkinID,playerPosition.x, playerPosition.y, playerPosition.z,1,false,true)	
			WEAPON.GIVE_DELAYED_WEAPON_TO_PED(testmodule.zombies[i], GAMEPLAY.GET_HASH_KEY("WEAPON_RAILGUN"), 1000, false)
			PED.SET_PED_AS_GROUP_MEMBER(testmodule.zombies[i], playerGroup)
			local task = AI.OPEN_SEQUENCE_TASK(0)
			
			AI.TASK_ENTER_VEHICLE(0, closestVehicle, -1, i -1, -1, 0, 1)
			if(i == 0 )then
				AI.TASK_VEHICLE_DRIVE_WANDER(0, closestVehicle, 1, 1)
				AI.TASK_VEHICLE_CHASE(0, playerPed)
			end
			AI.CLOSE_SEQUENCE_TASK(task)
			AI.TASK_PERFORM_SEQUENCE(testmodule.zombies[i], task)
			task = AI.CLEAR_SEQUENCE_TASK(task)
		end
		STREAMING.SET_MODEL_AS_NO_LONGER_NEEDED(zombieSkinID)
		testmodule.loaded = true
	end
	
    --print("Hello World! 2")
	
end

return testmodule